﻿
function renderTextHighlightsPerformanceWidget(data) {
    var totalResponse = 0;
    $.each(data, function () {
        totalResponse += parseInt(this.Value);
    });
    
    chart = am4core.create("highlightPerformance", am4charts.PieChart);
    chart.data = data;
    chart.numberFormatter.numberFormat = "#.";
    chart.innerRadius = am4core.percent(75);
    chart.radius = am4core.percent(99);
    chart.paddingLeft = 4;

    series = chart.series.push(new am4charts.PieSeries());
    series.dataFields.value = "Value";
    series.dataFields.category = "Category";
    series.labels.template.disabled = true;
    series.tooltip.fontSize = 12;
    series.slices.template.propertyFields.fill = "Color";
    series.slices.template.propertyFields.isActive = "pulled";

    chart.legend = new am4charts.Legend();
    chart.legend.markers.template.disabled = false;
    chart.legend.markers.template.width = 2;
    chart.legend.labels.template.text = "[bold {color} font-size:12px]{value.percent.formatNumber('#.0')}%[/]\n{name}";
    chart.legend.valueLabels.template.text = "";
    chart.legend.position = "right";
    chart.legend.paddingTop = -10;
    chart.legend.fontSize = 12;
    chart.legend.width = 100;
    chart.legend.itemContainers.template.clickable = false;
    chart.legend.itemContainers.template.focusable = false;
    chart.legend.scrollable = true;
    chart.legend.maxHeight = 148;

    // Setting the Text Highlighter Performance value at the middle of the performance chart
    var labelCount = series.createChild(am4core.Label);
    labelCount.text = totalResponse;
    labelCount.fontSize = 28;
    labelCount.horizontalCenter = "middle";
    labelCount.verticalCenter = "bottom";
    labelCount.fill = "black";

    var labelResponse = series.createChild(am4core.Label);
    labelResponse.text = createDashboardResources.TextHighlights;
    labelResponse.fontSize = 11;
    labelResponse.horizontalCenter = "middle";
    labelResponse.verticalCenter = "top";
    labelResponse.fill = "black";
}